/*
 * Decompiled with CFR 0.152.
 */
package adql.query.operand.function.geometry;

import adql.query.ADQLObject;
import adql.query.operand.ADQLColumn;
import adql.query.operand.ADQLOperand;
import adql.query.operand.function.geometry.GeometryFunction;

public class CentroidFunction
extends GeometryFunction {
    protected GeometryFunction.GeometryValue<GeometryFunction> parameter;

    public CentroidFunction(GeometryFunction.GeometryValue<GeometryFunction> geometryValue) throws NullPointerException {
        if (geometryValue == null) {
            throw new NullPointerException("The ADQL function CENTROID must have exactly one parameter !");
        }
        this.parameter = geometryValue;
    }

    public CentroidFunction(CentroidFunction centroidFunction) throws Exception {
        this.parameter = (GeometryFunction.GeometryValue)centroidFunction.parameter.getCopy();
    }

    @Override
    public ADQLObject getCopy() throws Exception {
        return new CentroidFunction(this);
    }

    @Override
    public String getName() {
        return "CENTROID";
    }

    @Override
    public boolean isNumeric() {
        return true;
    }

    @Override
    public boolean isString() {
        return false;
    }

    @Override
    public boolean isGeometry() {
        return false;
    }

    @Override
    public ADQLOperand[] getParameters() {
        return new ADQLOperand[]{this.parameter.getValue()};
    }

    @Override
    public int getNbParameters() {
        return 1;
    }

    @Override
    public ADQLOperand getParameter(int n) throws ArrayIndexOutOfBoundsException {
        if (n == 0) {
            return this.parameter.getValue();
        }
        throw new ArrayIndexOutOfBoundsException("No " + n + "-th parameter for the function \"" + this.getName() + "\" !");
    }

    @Override
    public ADQLOperand setParameter(int n, ADQLOperand aDQLOperand) throws ArrayIndexOutOfBoundsException, NullPointerException, Exception {
        if (n == 0) {
            ADQLOperand aDQLOperand2 = null;
            if (aDQLOperand == null) {
                throw new NullPointerException("Impossible to remove the only required parameter of the " + this.getName() + " function !");
            }
            if (aDQLOperand instanceof GeometryFunction.GeometryValue) {
                this.parameter = (GeometryFunction.GeometryValue)aDQLOperand;
            } else if (aDQLOperand instanceof ADQLColumn) {
                this.parameter.setColumn((ADQLColumn)aDQLOperand);
            } else if (aDQLOperand instanceof GeometryFunction) {
                this.parameter.setGeometry((GeometryFunction)aDQLOperand);
            } else {
                throw new Exception("Impossible to replace a GeometryValue/Column/GeometryFunction by a " + aDQLOperand.getClass().getName() + " (" + aDQLOperand.toADQL() + ") !");
            }
            return aDQLOperand2;
        }
        throw new ArrayIndexOutOfBoundsException("No " + n + "-th parameter for the function \"" + this.getName() + "\" !");
    }
}

